import java.util.concurrent.*;

class UnbemerkteAusnahme {
	public static void main(String[] args) {
		CompletableFuture<Integer> cf1 = CompletableFuture.supplyAsync(() -> {
			System.out.println("Thread(cf1):  " + Thread.currentThread().getName());
			if (true)
				throw new IllegalStateException("cf1 failed");
			return 1;
		});

		CompletableFuture<Integer> cf2 = cf1.thenApplyAsync(i -> {
			System.out.println("Thread(cf2):  " + Thread.currentThread().getName());
			return ++i;
		});

		CompletableFuture<Void> cf3 = cf2.thenAcceptAsync(i -> {
			System.out.println("Thread(cf3):  " + Thread.currentThread().getName());
			System.out.println("Ergebnis:     " + i);
		});

		ForkJoinPool.commonPool().awaitQuiescence(3000, TimeUnit.MILLISECONDS);
	}
}
